#include <iostream>
#include <cstdio>
#include <vector>
#include <array>
#include <string>
#include <algorithm>
#include <numeric>
#include <map>
#include <unordered_map>
#include <set>
#include <unordered_set>
#include <queue>
#include <cmath>
#include <climits>
#include <iomanip>
#include <limits>
#include <tuple>
#include <stack>
#include <bitset>
#include <cstring>
#include <sstream>
#include <functional>
#include <random>
using namespace std;

using ll = long long; 

void solve() {
    int n;
    cin >> n;
    vector<array<ll, 3>> pts(n);
    for (int i = 0; i < n; ++i) {
        cin >> pts[i][0];
        pts[i][2] = i;
    }
    for (int i = 0; i < n; ++i) {
        cin >> pts[i][1];
    }
    sort(pts.begin(), pts.end());
    vector<int> l(n), r(n), s;
    for (int i = 0; i < n; ++i) {
        while (!s.empty() && pts[s.back()][1] < pts[i][1]) {
            s.pop_back();
        }
        l[i] = s.empty() ? -1 : s.back();
        s.push_back(i);
    }
    s.clear();
    for (int i = n - 1; i >= 0; --i) {
        while (!s.empty() && pts[s.back()][1] < pts[i][1]) {
            s.pop_back();
        }
        r[i] = s.empty() ? -1 : s.back();
        s.push_back(i);
    }
    vector<ll> ans(n);
    for (int i = 0; i < n; ++i) {
        ll x1 = pts[i][0], y1 = pts[i][1];
        ll mn = 9e18;
        if (r[i] != -1) {
            ll x2 = pts[r[i]][0], y2 = pts[r[i]][1];
            mn = min(mn, llabs(x2 - x1 + y1 - y2));
        }
        if (l[i] != -1) {
            ll x2 = pts[l[i]][0], y2 = pts[l[i]][1];
            mn = min(mn, llabs(x1 - y2 + y1 - x2));
        }
        ans[pts[i][2]] = (mn == 9e18 ? -1 : mn);
    }
    for (int i = 0; i < n; ++i) {
        cout << ans[i] << '\n';
    }
}

signed main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    solve();
    return 0;
}